const CMD_PRIVATE_FIRMWARE_INFO_GET = 0xE0
const CMD_PRIVATE_FIRMWARE_WRITE_42 = 0xE1
const CMD_PRIVATE_FIRMWARE_WRITE_4 = 0xE2
const CMD_PRIVATE_RESET = 0xE3
const CMD_PRIVATE_ENTER_AUTO_TEST = 0xE4
const CMD_PRIVATE_DATA_GETVERSION = 0xE5
const CMD_PRIVATE_DATA_EXIT_AND_VERSION = 0xE6
const CMD_PRIVATE_DATA_WRITE_42 = 0xE7
const CMD_PRIVATE_DATA_WRITE_36 = 0xE8

function dev_cmd_private_firmware_info_get(select) {
    var array = new Uint8Array(2);
    array[0] = CMD_PRIVATE_FIRMWARE_INFO_GET;
    array[1] = select;
    return array;
}

function dev_cmd_private_firmware_write_42(crypt_mode, target_bin, pos, data_len) {
    var array = new Uint8Array(1 + 4 + data_len);
    array[0] = CMD_PRIVATE_FIRMWARE_WRITE_42;

    var addr = new Uint32Array(1);
    addr[0] = pos;
    array.set(new Uint8Array(addr.buffer), 1);

    var data = target_bin.slice(pos, pos + data_len);
    array.set(new Uint8Array(data), 1 + 4);

    return array;
}

function dev_cmd_private_firmware_write_4(crypt_mode, target_bin, pos, data_len) {
    var array = new Uint8Array(1 + 4 + data_len);
    array[0] = CMD_PRIVATE_FIRMWARE_WRITE_4;

    var addr = new Uint32Array(1);
    addr[0] = pos;
    array.set(new Uint8Array(addr.buffer), 1);

    var data = target_bin.slice(pos, pos + data_len);
    array.set(new Uint8Array(data), 1 + 4);

    return array;
}

function dev_cmd_private_reset() {
    var array = new Uint8Array(1);
    array[0] = CMD_PRIVATE_RESET;
    return array;
}

function dev_cmd_private_enter_auto_test() {
    var array = new Uint8Array(1);
    array[0] = CMD_PRIVATE_ENTER_AUTO_TEST;
    return array;
}

function dev_cmd_private_data_getversion() {
    var array = new Uint8Array(1);
    array[0] = CMD_PRIVATE_DATA_GETVERSION;
    return array;
}

function dev_cmd_private_data_exit_and_version() {
    var array = new Uint8Array(1);
    array[0] = CMD_PRIVATE_DATA_EXIT_AND_VERSION;
    return array;
}

function dev_cmd_private_data_write_42(target_bin, pos, data_len) {
    var array = new Uint8Array(1 + 4 + data_len);
    array[0] = CMD_PRIVATE_DATA_WRITE_42;

    var addr = new Uint32Array(1);
    addr[0] = pos;
    array.set(new Uint8Array(addr.buffer), 1);

    var data = target_bin.slice(pos, pos + data_len);
    array.set(new Uint8Array(data), 1 + 4);

    return array;
}

function dev_cmd_private_data_write_36(target_bin, pos, data_len) {
    var array = new Uint8Array(1 + 4 + data_len);
    array[0] = CMD_PRIVATE_DATA_WRITE_36;

    var addr = new Uint32Array(1);
    addr[0] = pos;
    array.set(new Uint8Array(addr.buffer), 1);

    var data = target_bin.slice(pos, pos + data_len);
    array.set(new Uint8Array(data), 1 + 4);

    return array;
}
